<?php

class ClaimController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
			'rights',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id=Null)
	{
            $id=$_REQUEST['Claim_id'];
            
           
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
            
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
        
	public function actionCreate()
	{
            
            
		$model=new Claim;
                $cmp=new Company;
                $assign=new Authassignment;
                $user=new User;
		$cnt=Claim::getNewFileNumber();
		
		//echo $_POST['Claim']['deducitible'];
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Claim']))
		{
                    foreach($cnt as $tot)
		{
			$file_no= $tot['file_no'];	
		}
		if(count($cnt)==0)
			$filenum=	date("mdY", time()).'-100001';
		else
		{
			$exploded_claim_name = explode("-", $file_no);

			$last_claim_number = str_replace("10000", "", $exploded_claim_name[1]);
		
			$new_claim_number = $last_claim_number + 1;
		
			$filenum = date("mdY", time()).'-10000'.$new_claim_number;

		}
			$model->attributes=$_POST['Claim'];
                        $model->file_no=$filenum;
                       // $model->claim_no=$claim_no;
			if($model->save())
				$this->redirect(array('view','Claim_id'=>$model->id));
		}
                    $q=new CDbCriteria;
                    $sql= 'SELECT id,name FROM company WHERE type_id LIKE :type1 or type_id=:type2 ';
       
        $cmpp= Yii::app()->db->createCommand($sql)->queryAll(true,array(':type1'=>1,'type2'=>8));
 
        $sql= 'SELECT id,name FROM company WHERE type_id LIKE :type1 or type_id=:type2 ';
       
        $tpacmpp= Yii::app()->db->createCommand($sql)->queryAll(true,array(':type1'=>4,'type2'=>8));
 
                //$q->compare('t.type_id','1');
                //$q->compare('t.type_id','8');
               // $cmpp=$cmp->findAll($q);
                
                 $q=new CDbCriteria;
                 $q->join="left join authassignment on authassignment.userid=t.id";
                 $q->select="t.id,t.first_name";
                 $q->compare('authassignment.itemname','Insurance Company Adjuster');
                 $usr=$user->findAll($q);
                  $branch = new Branch;
                 $state=new State;
		$states=$state->findAll('',array('id','name'));
                $country=new Country;
		$countries=$country->findAll('',array('id','name'));
		$this->render('create',array(
			'model'=>$model,
                        'cmp'=>$cmp,
                        'cmpp'=>$cmpp,
                        'usr'=>$usr,
                        'states'=>$states, 
                    'branch'=>$branch,
                    'countries'=>$countries,
                    'tpacmpp'=>$tpacmpp,
		));
	}
public function actionEmail()
	{
		/*$mail = new YiiMailer('email');  
            	
            	$mail->setFrom('noreply@claimflowsolutions.com', 'Claim Flow Solutions LLC');
            	$mail->setTo('dhimandee@gmail.com');
            	$mail->setCc('neetuverma26@gmail.com');            	
            	$mail->setSubject('New Email Notiication from Claimflow Solutions LLC');
            	$mail->setData(array('user' => $user,'creator'=>$creator, 'data'=>$arr));            
            	$mail->setBody('Simple message');
            	*/
            	/*if ($mail->send()) {
	                Yii::app()->user->setFlash('contact','Thank you for contacting us. We will respond to you as soon as possible.');                   
            	} else {
	                Yii::app()->user->setFlash('error','Error while sending email: '.$mail->getError());
            	}*/
		
		$this->render('email',array(
			//'model'=>$model,
		));
	}
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id=Null)
	{
            
                $id=$_REQUEST['Claim_id'];
               
		$model=$this->loadModel($id);
                $bran=new Branch;
                
                $q = new CDbCriteria;
                $q->select="t.*";
                if(!is_null($model->branch_id)){
                    $q->compare('t.id',$model->branch_id);
                    $branch=$bran->find($q);
                }else{
                    $branch = new Branch;
                }	
                $cmp=new Company;
                $q = new CDbCriteria;
                $q->select="t.*";
                if(!is_null($branch->company_id)){
                    $q->compare('t.id',$branch->company_id);
                    $comp=$cmp->find($q);
                }else{
                    $comp = new Company;
                }	
                $assign=new Authassignment;
                $user=new User;
                 $q=new CDbCriteria;
                $q->compare('t.type_id','1');
                $cmpp=$cmp->findAll($q);
                
                 $q=new CDbCriteria;
                $q->compare('t.company_id',$branch->company_id);
                $brchs=$bran->findAll($q);
                 $q=new CDbCriteria;
                 $q->join="left join authassignment on authassignment.userid=t.id";
                 $q->select="t.id,t.first_name";
                 $q->compare('authassignment.itemname','Insurance Company Adjuster');
                 $usr=$user->findAll($q);
                 
                 $state=new State;
		$states=$state->findAll('',array('id','name'));
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
                 $country=new Country;
		$countries=$country->findAll('',array('id','name'));
		if(isset($_POST['Claim']))
		{
			$model->attributes=$_POST['Claim'];
			if($model->save())
				$this->redirect(array('view','Claim_id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
                        'cmp'=>$comp,
                        'cmpp'=>$cmpp,
                        'usr'=>$usr,
                        'states'=>$states,
                        'branch'=>$brchs,
                        'countries'=>$countries
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            
		$dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}
        
        public function claimstatus($status)
        {
            
            switch ($status)
            {
                case 0:
                return "Opened Claim";
                 break;
                case 1:
                  return "Canceled Claim";
                 break;
                case 2:
                  return "Closed Claim";
                  break;
                case 3:
                    return "Completed Claim";
                    break;
                 case 4:
                    return "Deleted Claim";
                    break;
                
            }
                
            
        }
         public function allowedActions()
        { 
            return 'Changestatus,SimpleSearch,BasicSearch';
        }
        
          function  getability($claim_status)
        {
            $controller= $menu=Yii::app()->controller->id;
             $menu=$menu=Yii::app()->controller->action->id;
                 $m=$controller.".".$menu;
                 $md=new Menuitem;
                 $q=new CDbCriteria;
                 $q->select='t.item_id';
                 $q->compare('t.url',$m);
                 $mid=$md->findAll($q);
                 //var_dump($mid);
                $menuid=$mid[0]['item_id'];
            $tab=new Abilitytab;
                  $q=new CDbCriteria;
                  $q->select='t.id,t.ability_name';
                  $q->join='left join abilitytab on abilitytab.ability_id=t.id';
                 //$q->compare('abilitytab.claim_status',$claim_status);
                  $utype=UserController::getMe(Yii::app()->user->id);
                 $q->compare('abilitytab.usertype',ltrim(rtrim($utype)));
                // 
               
                 
                 
                 $q->compare('abilitytab.menu_id', $menuid);
                  //var_dump($q);
                  $abilities=array();
                    $abt=new Ability;
                               $abilities=$abt->findAll($q);
                              // var_dump($q);
                      
                     return $abilities;  
        }
        public function actionChangestatus()
        {
            $today=date('Y-m-d');
            if($_POST['abt']==19)
            {
                Appraisalcompanyinvoice::model()->updateAll(array('is_paid'=>1,'paid_date'=>$today), 'claim_id='.$_POST['claimid']) ;
            }
            else if($_POST['abt']==20)
            {
                
                Appraisalcompanyinvoice::model()->deleteAll(array("condition"=>"claim_id='".$_POST['claimid']."'"));
            }
            else if($_POST['abt']==24)
            {
                
                Appraisalinvoice::model()->updateAll(array('is_paid'=>1,'paid_date'=>$today), 'claim_id='.$_POST['claimid']) ;
            }
             else if($_POST['abt']==25)
            {
                
                Appraisalinvoice::model()->deleteAll(array("condition"=>"claim_id='".$_POST['claimid']."'"));
            }
             else if($_POST['abt']==28)
            {
                
                Deskreviewerinvoice::model()->updateAll(array('is_paid'=>1,'paid_date'=>$today), 'claim_id='.$_POST['claimid']) ;
            }
             else if($_POST['abt']==29)
            {
                
                Deskreviewerinvoice::model()->deleteAll(array("condition"=>"claim_id='".$_POST['claimid']."'"));
            }
             else if($_POST['abt']==31)
            {
                
                Cfsinvoice::model()->updateAll(array('is_paid'=>1,'paid_date'=>$today), 'claim_id='.$_POST['claimid']) ;
            }
             else if($_POST['abt']==108)
            {
                
                Callcenterinvoice::model()->deleteAll(array("condition"=>"claim_id='".$_POST['claimid']."'"));
            }
             else if($_POST['abt']==51)
            {
                
                Callcenterinvoice::model()->updateAll(array('is_paid'=>1,'paid_date'=>$today), 'claim_id='.$_POST['claimid']) ;
            }
             else if($_POST['abt']==32)
            {
                
                Cfsinvoice::model()->deleteAll(array("condition"=>"claim_id='".$_POST['claimid']."'"));
            }
             else if($_POST['abt']==63)
            {
                
                Bodyshopinvoice::model()->updateAll(array('is_paid'=>1,'paid_date'=>$today), 'claim_id='.$_POST['claimid']) ;
            }
             else if($_POST['abt']==64)
            {
                
                Bodyshopinvoice::model()->deleteAll(array("condition"=>"claim_id='".$_POST['claimid']."'"));
            }
             else if($_POST['abt']==36)
            {
                
                Payout::model()->updateAll(array('is_claim_settled'=>'Yes'), 'claim_id='.$_POST['claimid'].' and type_id=2') ;
            }
             else if($_POST['abt']==34)
            {
                
                Payout::model()->updateAll(array('is_claim_settled'=>'Yes'), 'claim_id='.$_POST['claimid'].' and type_id=1') ;
            }
             else if($_POST['abt']==37)
            {
                
                Claim::model()->updateAll(array('status'=>'0','reopened'=>'1'), 'id='.$_POST['claimid']) ;
            }
            else if($_POST['abt']==79)
            {
                
                Referencenumber::model()->deleteAll(array("condition"=>"claim_id='".$_POST['claimid']."'"));
            }
            else
            {
             $model=new Claim;
            // Claim::updateByPk( $_POST['claimid'], array('status'=>$_POST['status']));
             Claim::model()->updateByPk($_POST['claimid'], array('status'=>$_POST['status']));
            }
        }
            public function actionSearch()
            {
                $model=new Claim;
                  // clear any default values
		if(isset($_REQUEST['Claim']))
                {
                   $criteria=new CDbCriteria;
//echo $model->$_POST['Claim']['file_no'];
			
		$criteria->compare('file_no',$_REQUEST['Claim']['file_no']);
		$criteria->compare('claim_no',$_REQUEST['Claim']['claim_no']);
		
		
		$criteria->compare('status',$_REQUEST['Claim']['status']);
	
		$criteria->compare('policy_no',$_REQUEST['Claim']['policy_no']);
		
		$criteria->compare('date_of_loss',$_REQUEST['Claim']['date_of_loss']);
		$criteria->compare('assignment_type',$_REQUEST['Claim']['assignment_type']);
		
		
		$criteria->compare('c_first_name',$_REQUEST['Claim']['c_first_name']);
		$criteria->compare('c_last_name',$_REQUEST['Claim']['c_last_name']);
		
		
		$criteria->compare('c_zip',$_REQUEST['Claim']['c_zip']);
		
		
		$criteria->compare('c_work',$_REQUEST['Claim']['c_work']);
		
		$criteria->compare('i_first_name',$_REQUEST['Claim']['i_first_name']);
		$criteria->compare('i_last_name',$_REQUEST['Claim']['i_last_name']);
		
		$criteria->compare('i_zip',$_REQUEST['Claim']['i_zip']);
		
		$criteria->compare('i_cell',$_REQUEST['Claim']['i_cell']);
		
		$criteria->compare('o_first_name',$_REQUEST['Claim']['o_first_name']);
		$criteria->compare('o_last_name',$_REQUEST['Claim']['o_last_name']);
		
		$criteria->compare('o_zip',$_REQUEST['Claim']['o_zip']);
		
		$criteria->compare('o_work',$_REQUEST['Claim']['o_work']);
		
		
		
		$criteria->compare('v_year',$_REQUEST['Claim']['v_year']);
		$criteria->compare('v_make_id',$_REQUEST['Claim']['v_make_id']);
		
		$criteria->compare('v_submodel',$_REQUEST['Claim']['v_submodel']);
		$criteria->compare('v_lien_holder',$_REQUEST['Claim']['v_lien_holder']);
		
		$criteria->compare('v_plate_no',$_REQUEST['Claim']['v_plate_no']);
		
		

                $model=$model->find($criteria);
               if(count($model)>0)
               {
		$dataProvider= new CActiveDataProvider($model, array(
			'criteria'=>$criteria,
		));
                 $itemCount=$dataProvider->itemCount;

                        //if($itemCount>0)
                        //{
                 
                     
                            $this->render('index',array(
                                    'dataProvider'=>$dataProvider,
                                   // 'abilities'=>$abilities,
                            ));
                        }
                        
                            else { 
                                //echo "No Result found";
                                $model=new Claim;
                              
                                $this->render('search',array(
                                                   'model'=>$model,
                                                   
                                           ));
                            
                            }
                }
                else
                {
              $this->render('search',array(
			'model'=>$model,
		));
                }
            }
            public function actionNew()//New claim Inbox
           {
                 $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }
            public function actionFranchise()//Assigned to Branch/Franchise
            {
                 $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
                
            }
             public function actionPending()//Pending Assignment Acceptance
            {
                 $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
                
            }
             public function actionPaindingReviewCompletion()//Pending Review/Completion
           {
                 $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }
            
             public function actionProcess()//In Process
           {
                 $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }
            public function actionViewClosed()//View Closed Claim
            {
                $model=new Claim;
                $criteria=new CDbCriteria;
                     $criteria->condition = " status =2";
                     $dataProvider= new CActiveDataProvider($model, array(
			'criteria'=>$criteria,
		));
                //$dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }
             public function actionViewCancelded()//View Canceled Claim
            {
                  $model=new Claim;
                $criteria=new CDbCriteria;
                     $criteria->condition = " status =1";
                     $dataProvider= new CActiveDataProvider($model, array(
			'criteria'=>$criteria,
		));
               // $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }
            
             public function actionViewDeleted()//View Deleted Claim
            {
                  $model=new Claim;
                $criteria=new CDbCriteria;
                     $criteria->condition = " status =4";
                     $dataProvider= new CActiveDataProvider($model, array(
			'criteria'=>$criteria,
		));
               // $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }
            public function actionIA()//Assigned To IA
            {
                $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }
           /* public function actionPendingcomp()//Reviewed / Pending Final Completion
            {
                $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }*/
            public function actionCompleted()//Marked Completed by Assignee
            {
                $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }
             public function actionEstimator()//Assigned to Estimator
            {
                $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }
             public function actionDispatch()//Assigned To Dispatch
            {
                $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }
             public function actionOpen()//View Open Claim
            {
                 $model=new Claim;
                $criteria=new CDbCriteria;
                     $criteria->condition = " status =0";
                     $dataProvider= new CActiveDataProvider($model, array(
			'criteria'=>$criteria,
		));
                //$dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }
             public function actionUnassigned()//UnAssigned Claims
           {
                 $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }
            
             public function actionAssign()//Assigned Claims
           {
                 $dataProvider=new CActiveDataProvider('Claim');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
            }
            public function actionBasicSearch()
            {
                $model=new Claim;
                  // clear any default values
		if(isset($_REQUEST['Claim']))
                {
                   $criteria=new CDbCriteria;
//echo $model->$_POST['Claim']['file_no'];
			
		$criteria->compare('file_no',$_REQUEST['Claim']['file_no']);
		$criteria->compare('claim_no',$_REQUEST['Claim']['claim_no']);
		
		
		$criteria->compare('status',$_REQUEST['Claim']['status']);
	
		$criteria->compare('policy_no',$_REQUEST['Claim']['policy_no']);
		
		$criteria->compare('date_of_loss',$_REQUEST['Claim']['date_of_loss']);
		$criteria->compare('assignment_type',$_REQUEST['Claim']['assignment_type']);
		
		
		$criteria->compare('v_year',$_REQUEST['Claim']['v_year']);
		$criteria->compare('v_make_id',$_REQUEST['Claim']['v_make_id']);
		
		$criteria->compare('v_submodel',$_REQUEST['Claim']['v_submodel']);
		$criteria->compare('v_lien_holder',$_REQUEST['Claim']['v_lien_holder']);
		
		$criteria->compare('v_plate_no',$_REQUEST['Claim']['v_plate_no']);
		
		

                $model=$model->find($criteria);
               if(count($model)>0)
               {
		$dataProvider= new CActiveDataProvider($model, array(
			'criteria'=>$criteria,
		));
                 $itemCount=$dataProvider->itemCount;

                        //if($itemCount>0)
                        //{
                 $tab=new Abilitytab;
                  $q=new CDbCriteria;
                  $q->select='t.id,t.ability_name';
                  $q->join='left join abilitytab on abilitytab.ability_id=t.id';
                  $q->compare('abilitytab.claim_status','0');
                  $utype=UserController::getMe(Yii::app()->user->id);
                 // $q->compare('abilitytab.usertype',$utype);
                  
                    $abt=new Ability;
                               $abilities=$abt->findAll($q,array('t.id,t.ability_name'));
                     
                            $this->render('index',array(
                                    'dataProvider'=>$dataProvider,
                                    'abilities'=>$abilities,
                            ));
                        }
                        
                            else { 
                                //echo "No Result found";
                                $model=new Claim;
                              
                                $this->render('basicsearch',array(
                                                   'model'=>$model,
                                                   
                                           ));
                            
                            }
                }
                else
                {
              $this->render('basicsearch',array(
			'model'=>$model,
		));
                }
                
            }
            public function actionSimpleSearch()
            {
                 $model=new Claim;
                 if(isset($_REQUEST['Claim']))
                 {
                     $criteria=new CDbCriteria;
                     $criteria->condition = " file_no like '%".$_POST['Claim']['file_no']."%'";
                    // var_dump($criteria);
                   //$model = Claim::model()->findAll($criteria);
                  // var_dump($model);
                   if(count($model)>0)
               {
		$dataProvider= new CActiveDataProvider($model, array(
			'criteria'=>$criteria,
		));
                 $itemCount=$dataProvider->itemCount;

                        //if($itemCount>0)
                        //{
                 $tab=new Abilitytab;
                  $q=new CDbCriteria;
                  $q->select='t.id,t.ability_name';
                  $q->join='left join abilitytab on abilitytab.ability_id=t.id';
                   $q->compare('abilitytab.claim_status','0');
                  $utype=UserController::getMe(Yii::app()->user->id);
                 // $q->compare('abilitytab.usertype',$utype);
                  
                    $abt=new Ability;
                               $abilities=$abt->findAll($q,array('t.id,t.ability_name'));
                     
                            $this->render('index',array(
                                    'dataProvider'=>$dataProvider,
                                    'abilities'=>$abilities,
                            ));
                   
                 }
                 else
                 {
                    $this->render('simplesearch',array(
			'model'=>$model,
		)); 
                 }
                 
            }  else {
                $this->render('simplesearch',array(
			'model'=>$model,
		));
            }
                
            }
	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Claim('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Claim']))
			$model->attributes=$_GET['Claim'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Claim the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Claim::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested claim does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Claim $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='claim-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
